/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validator;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorRouteTest
extends ContextTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(ValidatorRouteTest.class);
    private static final String VALIDATOR_INVOKED = "validator-invoked";

    @Test
    public void testPredicateValidator() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"{name:XOrder}");
        Exchange answerEx = this.template.send("direct:predicate", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"{name:XOrderResponse}", (Object)answerEx.getIn().getBody(String.class));
    }

    @Test
    public void testEndpointValidator() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"<XOrder/>");
        Exchange answerEx = this.template.send("direct:endpoint", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"<XOrderResponse/>", (Object)answerEx.getMessage().getBody(String.class));
        Assertions.assertEquals(MyXmlEndpoint.class, (Object)answerEx.getProperty(VALIDATOR_INVOKED));
    }

    @Test
    public void testCustomValidator() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"name=XOrder");
        Exchange answerEx = this.template.send("direct:custom", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"name=XOrderResponse", (Object)answerEx.getMessage().getBody(String.class));
        Assertions.assertEquals(OtherXOrderResponseValidator.class, (Object)answerEx.getProperty(VALIDATOR_INVOKED));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.validator().type("json").withExpression(this.bodyAs(String.class).contains((Object)"{name:XOrder}"));
                this.from("direct:predicate").inputTypeWithValidate("json:JsonXOrder").outputType("json:JsonXOrderResponse").setBody((Expression)this.simple("{name:XOrderResponse}"));
                ValidatorRouteTest.this.context.addComponent("myxml", (Component)new MyXmlComponent());
                this.validator().type("xml:XmlXOrderResponse").withUri("myxml:endpoint");
                this.from("direct:endpoint").inputType("xml:XmlXOrder").outputTypeWithValidate("xml:XmlXOrderResponse").validate(this.exchangeProperty(ValidatorRouteTest.VALIDATOR_INVOKED).isNull()).setBody((Expression)this.simple("<XOrderResponse/>"));
                this.validator().type("other:OtherXOrder").withJava(OtherXOrderValidator.class);
                this.validator().type("other:OtherXOrderResponse").withJava(OtherXOrderResponseValidator.class);
                this.from("direct:custom").inputTypeWithValidate("other:OtherXOrder").outputTypeWithValidate("other:OtherXOrderResponse").validate(this.exchangeProperty(ValidatorRouteTest.VALIDATOR_INVOKED).isEqualTo(OtherXOrderValidator.class)).setBody((Expression)this.simple("name=XOrderResponse"));
            }
        };
    }

    public static class MyXmlEndpoint
    extends DefaultEndpoint {
        public Producer createProducer() {
            return new DefaultAsyncProducer((Endpoint)this){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    exchange.setProperty(ValidatorRouteTest.VALIDATOR_INVOKED, MyXmlEndpoint.class);
                    Assertions.assertEquals((Object)"<XOrderResponse/>", (Object)exchange.getIn().getBody());
                    callback.done(true);
                    return true;
                }
            };
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        protected String createEndpointUri() {
            return "myxml:endpoint";
        }
    }

    public static class OtherXOrderResponseValidator
    extends Validator {
        public void validate(Message message, DataType type) {
            message.getExchange().setProperty(ValidatorRouteTest.VALIDATOR_INVOKED, OtherXOrderResponseValidator.class);
            Assertions.assertEquals((Object)"name=XOrderResponse", (Object)message.getBody());
            LOG.info("Java validation: other XOrderResponse");
        }
    }

    public static class OtherXOrderValidator
    extends Validator {
        public void validate(Message message, DataType type) {
            message.getExchange().setProperty(ValidatorRouteTest.VALIDATOR_INVOKED, OtherXOrderValidator.class);
            Assertions.assertEquals((Object)"name=XOrder", (Object)message.getBody());
            LOG.info("Java validation: other XOrder");
        }
    }

    public static class MyXmlComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyXmlEndpoint();
        }
    }
}

