/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidatorContractTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInputTypeOnly() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverters((Object)new MyTypeConverters());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.validator().type(A.class).withUri("direct:validator");
                this.from("direct:a").inputTypeWithValidate(A.class).to("mock:a");
                this.from("direct:validator").to("mock:validator");
            }
        });
        this.context.start();
        MockEndpoint mocka = (MockEndpoint)this.context.getEndpoint("mock:a", MockEndpoint.class);
        MockEndpoint mockv = (MockEndpoint)this.context.getEndpoint("mock:validator", MockEndpoint.class);
        mocka.setExpectedCount(1);
        mockv.setExpectedCount(1);
        Object answer = this.template.requestBody("direct:a", (Object)"foo");
        mocka.assertIsSatisfied();
        mockv.assertIsSatisfied();
        Exchange exa = (Exchange)mocka.getExchanges().get(0);
        Assertions.assertEquals(A.class, exa.getIn().getBody().getClass());
        Exchange exv = (Exchange)mockv.getExchanges().get(0);
        Assertions.assertEquals(A.class, exv.getIn().getBody().getClass());
        Assertions.assertEquals(A.class, answer.getClass());
    }

    @Test
    public void testOutputTypeOnly() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverters((Object)new MyTypeConverters());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.validator().type(A.class).withUri("direct:validator");
                this.from("direct:a").outputTypeWithValidate(A.class).to("mock:a");
                this.from("direct:validator").to("mock:validator");
            }
        });
        this.context.start();
        MockEndpoint mocka = (MockEndpoint)this.context.getEndpoint("mock:a", MockEndpoint.class);
        MockEndpoint mockv = (MockEndpoint)this.context.getEndpoint("mock:validator", MockEndpoint.class);
        mocka.setExpectedCount(1);
        mockv.setExpectedCount(1);
        Object answer = this.template.requestBody("direct:a", (Object)"foo");
        mocka.assertIsSatisfied();
        mockv.assertIsSatisfied();
        Exchange exa = (Exchange)mocka.getExchanges().get(0);
        Assertions.assertEquals((Object)"foo", (Object)exa.getIn().getBody());
        Exchange exv = (Exchange)mockv.getExchanges().get(0);
        Assertions.assertEquals(A.class, exv.getIn().getBody().getClass());
        Assertions.assertEquals(A.class, answer.getClass());
    }

    public static class MyTypeConverters
    implements TypeConverters {
        @Converter
        public A toA(String in) {
            return new A();
        }
    }

    public static class A {
    }
}

