/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validator;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Message;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanValidatorOutputValidateTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.validator().type("toValidate").withBean("testValidator");
                ((OnExceptionDefinition)this.onException(ValidationException.class).handled(true).log("Invalid validation: ${exception.message}")).to("mock:invalid");
                this.from("direct:in").outputTypeWithValidate("toValidate").to("mock:out");
            }
        };
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry registry = super.createCamelRegistry();
        registry.bind("testValidator", (Object)new TestValidator());
        return registry;
    }

    @Test
    public void testValid() throws InterruptedException {
        this.getMockEndpoint("mock:out").expectedMessageCount(1);
        this.getMockEndpoint("mock:invalid").expectedMessageCount(0);
        this.template.sendBody("direct:in", (Object)"valid");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInvalid() throws InterruptedException {
        this.getMockEndpoint("mock:out").expectedMessageCount(1);
        this.getMockEndpoint("mock:invalid").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:in", (Object)"wrong");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            BeanValidatorOutputValidateTest.assertIsInstanceOf(ValidationException.class, e.getCause());
            Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("Wrong content"));
        }
        this.assertMockEndpointsSatisfied();
    }

    public static class TestValidator
    extends Validator {
        private static final Logger LOG = LoggerFactory.getLogger(TestValidator.class);

        public void validate(Message message, DataType type) throws ValidationException {
            Object body = message.getBody();
            LOG.info("Validating : [{}]", body);
            if (!(body instanceof String) || !body.equals("valid")) {
                throw new ValidationException(message.getExchange(), "Wrong content");
            }
            LOG.info("OK");
        }
    }
}

