/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.support.processor.validation.SchemaValidationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class DefaultValidationErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testWarning() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.warning(new SAXParseException("foo", this.createLocator(1, 2)));
        Assertions.assertTrue((boolean)eh.isValid());
    }

    @Test
    public void testError() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        Assertions.assertFalse((boolean)eh.isValid());
    }

    @Test
    public void testFatalError() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.fatalError(new SAXParseException("foo", this.createLocator(5, 8)));
        Assertions.assertFalse((boolean)eh.isValid());
    }

    @Test
    public void testReset() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.fatalError(new SAXParseException("foo", this.createLocator(5, 8)));
        Assertions.assertFalse((boolean)eh.isValid());
        eh.reset();
        Assertions.assertTrue((boolean)eh.isValid());
    }

    @Test
    public void testHandleErrors() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        eh.error(new SAXParseException("bar", this.createLocator(9, 12)));
        eh.fatalError(new SAXParseException("cheese", this.createLocator(13, 17)));
        Assertions.assertFalse((boolean)eh.isValid());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            eh.handleErrors((Exchange)exchange, (Object)this.createScheme());
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (SchemaValidationException e) {
            Assertions.assertEquals((int)2, (int)e.getErrors().size());
            Assertions.assertEquals((int)1, (int)e.getFatalErrors().size());
            Assertions.assertEquals((int)0, (int)e.getWarnings().size());
            Assertions.assertNotNull((Object)e.getSchema());
            Assertions.assertNotNull((Object)e.getExchange());
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Validation failed for: org.apache.camel.processor.validation.DefaultValidationErrorHandlerTest"));
            Assertions.assertTrue((boolean)e.getMessage().contains("fatal errors: ["));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: cheese, Line : 13, Column : 17"));
            Assertions.assertTrue((boolean)e.getMessage().contains("errors: ["));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: foo, Line : 3, Column : 5"));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: bar, Line : 9, Column : 12"));
            Assertions.assertTrue((boolean)e.getMessage().contains("Exchange[]"));
        }
    }

    @Test
    public void testHandleErrorsResult() throws Exception {
        DefaultValidationErrorHandler eh = new DefaultValidationErrorHandler();
        eh.error(new SAXParseException("foo", this.createLocator(3, 5)));
        eh.error(new SAXParseException("bar", this.createLocator(9, 12)));
        Assertions.assertFalse((boolean)eh.isValid());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        try {
            eh.handleErrors((Exchange)exchange, this.createScheme(), (Result)new SAXResult());
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (SchemaValidationException e) {
            Assertions.assertEquals((int)2, (int)e.getErrors().size());
            Assertions.assertEquals((int)0, (int)e.getFatalErrors().size());
            Assertions.assertEquals((int)0, (int)e.getWarnings().size());
            Assertions.assertNotNull((Object)e.getSchema());
            Assertions.assertNotNull((Object)e.getExchange());
            Assertions.assertTrue((boolean)e.getMessage().startsWith("Validation failed for: org.apache.camel.processor.validation.DefaultValidationErrorHandlerTest"));
            Assertions.assertTrue((boolean)e.getMessage().contains("errors: ["));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: foo, Line : 3, Column : 5"));
            Assertions.assertTrue((boolean)e.getMessage().contains("org.xml.sax.SAXParseException: bar, Line : 9, Column : 12"));
            Assertions.assertTrue((boolean)e.getMessage().contains("Exchange[]"));
        }
    }

    private Schema createScheme() {
        return new Schema(){

            @Override
            public Validator newValidator() {
                return null;
            }

            @Override
            public ValidatorHandler newValidatorHandler() {
                return null;
            }
        };
    }

    private Locator createLocator(final int line, final int column) {
        return new Locator(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public int getLineNumber() {
                return line;
            }

            @Override
            public int getColumnNumber() {
                return column;
            }
        };
    }
}

