/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultDataFormat;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerRouteTest
extends ContextTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(TransformerRouteTest.class);

    @Test
    public void testJavaTransformer() throws Exception {
        MockEndpoint abcresult = this.getMockEndpoint("mock:abcresult");
        abcresult.expectedMessageCount(1);
        abcresult.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                LOG.info("Asserting String -> XOrderResponse conversion");
                Assertions.assertEquals(XOrderResponse.class, exchange.getIn().getBody().getClass());
            }
        });
        MockEndpoint xyzresult = this.getMockEndpoint("mock:xyzresult");
        xyzresult.expectedMessageCount(1);
        xyzresult.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                LOG.info("Asserting String -> XOrderResponse conversion is not yet performed");
                Assertions.assertEquals((Object)"response", (Object)exchange.getIn().getBody());
            }
        });
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)new AOrder());
        Exchange answerEx = this.template.send("direct:abc", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals(AOrderResponse.class, answerEx.getMessage().getBody().getClass());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDataFormatTransformer() throws Exception {
        MockEndpoint xyzresult = this.getMockEndpoint("mock:xyzresult");
        xyzresult.expectedMessageCount(1);
        xyzresult.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                LOG.info("Asserting String -> XOrderResponse conversion is not yet performed");
                Assertions.assertEquals((Object)"response", (Object)exchange.getIn().getBody());
            }
        });
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        ((DataTypeAware)exchange.getIn()).setBody((Object)"{name:XOrder}", new DataType("json:JsonXOrder"));
        Exchange answerEx = this.template.send("direct:dataFormat", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"{name:XOrderResponse}", (Object)answerEx.getMessage().getBody(String.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointTransformer() throws Exception {
        MockEndpoint xyzresult = this.getMockEndpoint("mock:xyzresult");
        xyzresult.expectedMessageCount(1);
        xyzresult.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                LOG.info("Asserting String -> XOrderResponse conversion is not yet performed");
                Assertions.assertEquals((Object)"response", (Object)exchange.getIn().getBody());
            }
        });
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"<XOrder/>");
        Exchange answerEx = this.template.send("direct:endpoint", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"<XOrderResponse/>", (Object)answerEx.getMessage().getBody(String.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testCustomTransformer() throws Exception {
        MockEndpoint xyzresult = this.getMockEndpoint("mock:xyzresult");
        xyzresult.expectedMessageCount(1);
        xyzresult.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                LOG.info("Asserting String -> XOrderResponse conversion is not yet performed");
                Assertions.assertEquals((Object)"response", (Object)exchange.getIn().getBody());
            }
        });
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context, ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"name=XOrder");
        Exchange answerEx = this.template.send("direct:custom", (Exchange)exchange);
        if (answerEx.getException() != null) {
            throw answerEx.getException();
        }
        Assertions.assertEquals((Object)"name=XOrderResponse", (Object)answerEx.getMessage().getBody(String.class));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void shouldKeepDataTypeAcrossRoutes() throws Exception {
        MockEndpoint customDataTypeResult = this.getMockEndpoint("mock:testDataType");
        customDataTypeResult.expectedMessageCount(1);
        Exchange answerCustomDataType = this.template.send("direct:testDataType", ex -> ((DataTypeAware)ex.getIn()).setBody((Object)"my fake content", new DataType("myDataType")));
        if (answerCustomDataType.getException() != null) {
            throw answerCustomDataType.getException();
        }
        TransformerRouteTest.assertIsInstanceOf(MyDataType.class, answerCustomDataType.getIn().getBody());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TransformerRouteTest.this.context.getTypeConverterRegistry().addTypeConverters((Object)new MyTypeConverters());
                ((RouteDefinition)((RouteDefinition)this.from("direct:abc").inputType(AOrder.class).outputType(AOrderResponse.class).process(new Processor(){

                    public void process(Exchange exchange) {
                        LOG.info("Asserting input -> AOrder conversion");
                        Assertions.assertEquals(AOrder.class, exchange.getIn().getBody().getClass());
                    }
                })).to(ExchangePattern.InOut, "direct:xyz")).to("mock:abcresult");
                ((RouteDefinition)this.from("direct:xyz").inputType(XOrder.class).outputType(XOrderResponse.class).process(new Processor(){

                    public void process(Exchange exchange) {
                        LOG.info("Asserting input -> XOrder conversion");
                        Assertions.assertEquals(XOrder.class, exchange.getIn().getBody().getClass());
                        exchange.getIn().setBody((Object)"response");
                    }
                })).to("mock:xyzresult");
                this.transformer().scheme("json").withDataFormat((DataFormatDefinition)new MyJsonDataFormatDefinition());
                this.from("direct:dataFormat").inputType("json:JsonXOrder").outputType("json:JsonXOrderResponse").to(ExchangePattern.InOut, "direct:xyz");
                TransformerRouteTest.this.context.addComponent("myxml", (Component)new MyXmlComponent());
                this.transformer().fromType("xml:XmlXOrder").toType(XOrder.class).withUri("myxml:endpoint");
                this.transformer().fromType(XOrderResponse.class).toType("xml:XmlXOrderResponse").withUri("myxml:endpoint");
                this.from("direct:endpoint").inputType("xml:XmlXOrder").outputType("xml:XmlXOrderResponse").to(ExchangePattern.InOut, "direct:xyz");
                this.transformer().fromType("other:OtherXOrder").toType(XOrder.class).withJava(OtherToXOrderTransformer.class);
                this.transformer().fromType(XOrderResponse.class).toType("other:OtherXOrderResponse").withJava(XOrderResponseToOtherTransformer.class);
                this.from("direct:custom").inputType("other:OtherXOrder").outputType("other:OtherXOrderResponse").to(ExchangePattern.InOut, "direct:xyz");
                this.transformer().name("myDataType").withDataFormat((DataFormatDefinition)new MyDataFormatDefinition());
                this.from("direct:testDataType").inputTypeWithValidate("myDataType").to("direct:testDataTypeStep2");
                this.from("direct:testDataTypeStep2").inputType(MyDataType.class).to("mock:testDataType");
                this.validator().type("myDataType").withExpression(this.bodyAs(String.class).contains((Object)"fake"));
                this.transformer().withDefaults();
                this.transformer().scan("com.apache.camel.processor.transformer.custom");
            }
        };
    }

    public static class AOrder {
    }

    public static class AOrderResponse {
    }

    public static class MyDataType {
    }

    public static class XOrderResponse {
    }

    public static class XOrder {
    }

    public static class XOrderResponseToOtherTransformer
    extends Transformer {
        public void transform(Message message, DataType from, DataType to) {
            LOG.info("Bean: XOrderResponse -> Other");
            message.setBody((Object)"name=XOrderResponse");
        }
    }

    public static class OtherToXOrderTransformer
    extends Transformer {
        public void transform(Message message, DataType from, DataType to) {
            Assertions.assertEquals((Object)"name=XOrder", (Object)message.getBody());
            LOG.info("Bean: Other -> XOrder");
            message.setBody((Object)new XOrder());
        }
    }

    public static class MyXmlEndpoint
    extends DefaultEndpoint {
        public Producer createProducer() {
            return new DefaultAsyncProducer((Endpoint)this){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    Object input = exchange.getIn().getBody();
                    if (input instanceof XOrderResponse) {
                        LOG.info("Endpoint: XOrderResponse -> XML");
                        exchange.getIn().setBody((Object)"<XOrderResponse/>");
                    } else {
                        Assertions.assertEquals((Object)"<XOrder/>", (Object)input);
                        LOG.info("Endpoint: XML -> XOrder");
                        exchange.getIn().setBody((Object)new XOrder());
                    }
                    callback.done(true);
                    return true;
                }
            };
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        protected String createEndpointUri() {
            return "myxml:endpoint";
        }
    }

    public static class MyXmlComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyXmlEndpoint();
        }
    }

    public static class MyJsonDataFormatDefinition
    extends DataFormatDefinition {
        public MyJsonDataFormatDefinition() {
            super((DataFormat)new DefaultDataFormat(){

                public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
                    Assertions.assertEquals(XOrderResponse.class, graph.getClass(), (String)graph.toString());
                    LOG.info("DataFormat: XOrderResponse -> JSON");
                    stream.write("{name:XOrderResponse}".getBytes());
                }

                public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
                    StringBuilder input = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            input.append(line);
                        }
                    }
                    Assertions.assertEquals((Object)"{name:XOrder}", (Object)input.toString());
                    LOG.info("DataFormat: JSON -> XOrder");
                    return new XOrder();
                }
            });
        }
    }

    public static class MyDataFormatDefinition
    extends DataFormatDefinition {
        public MyDataFormatDefinition() {
            super((DataFormat)new DefaultDataFormat(){

                public void marshal(Exchange exchange, Object graph, OutputStream stream) {
                    throw new UnsupportedOperationException();
                }

                public Object unmarshal(Exchange exchange, InputStream stream) {
                    return new MyDataType();
                }
            });
        }
    }

    public static class MyTypeConverters
    implements TypeConverters {
        @Converter
        public AOrder toAOrder(String order) {
            LOG.info("TypeConverter: String -> AOrder");
            return new AOrder();
        }

        @Converter
        public XOrder toXOrder(AOrder aorder) {
            LOG.info("TypeConverter: AOrder -> XOrder");
            return new XOrder();
        }

        @Converter
        public XOrderResponse toXOrderResponse(String res) {
            LOG.info("TypeConverter: String -> XOrderResponse");
            return new XOrderResponse();
        }

        @Converter
        public AOrderResponse toAOrderResponse(XOrderResponse xres) {
            LOG.info("TypeConverter: XOrderResponse -> AOrderResponse");
            return new AOrderResponse();
        }
    }
}

