/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverters;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeAware;
import org.apache.camel.support.DefaultDataFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransformerContractTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInputTypeOnly() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverters((Object)new MyTypeConverters());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").inputType(A.class).to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:a", MockEndpoint.class);
        mock.setExpectedCount(1);
        Object answer = this.template.requestBody("direct:a", (Object)"foo");
        mock.assertIsSatisfied();
        Exchange ex = (Exchange)mock.getExchanges().get(0);
        Assertions.assertEquals(A.class, ex.getIn().getBody().getClass());
        Assertions.assertEquals(A.class, answer.getClass());
    }

    @Test
    public void testOutputTypeOnly() throws Exception {
        this.context.getTypeConverterRegistry().addTypeConverters((Object)new MyTypeConverters());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:a").outputType(A.class).to("mock:a");
            }
        });
        this.context.start();
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:a", MockEndpoint.class);
        mock.setExpectedCount(1);
        Object answer = this.template.requestBody("direct:a", (Object)"foo");
        mock.assertIsSatisfied();
        Exchange ex = (Exchange)mock.getExchanges().get(0);
        Assertions.assertEquals((Object)"foo", (Object)ex.getIn().getBody());
        Assertions.assertEquals(A.class, answer.getClass());
    }

    @Test
    public void testScheme() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.transformer().scheme("xml").withDataFormat((DataFormatDefinition)new MyDataFormatDefinition());
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").inputType("xml").outputType("xml").to("mock:a")).to("direct:b")).to("mock:a2");
                ((RouteDefinition)this.from("direct:b").inputType("java").outputType("java").to("mock:b")).process(ex -> ex.getIn().setBody((Object)new B()));
            }
        });
        this.context.start();
        MockEndpoint mocka = (MockEndpoint)this.context.getEndpoint("mock:a", MockEndpoint.class);
        MockEndpoint mocka2 = (MockEndpoint)this.context.getEndpoint("mock:a2", MockEndpoint.class);
        MockEndpoint mockb = (MockEndpoint)this.context.getEndpoint("mock:b", MockEndpoint.class);
        mocka.setExpectedCount(1);
        mocka2.setExpectedCount(1);
        mockb.setExpectedCount(1);
        Exchange answer = this.template.send("direct:a", ex -> {
            DataTypeAware message = (DataTypeAware)ex.getIn();
            message.setBody((Object)"<foo/>", new DataType("xml"));
        });
        mocka.assertIsSatisfied();
        mocka2.assertIsSatisfied();
        mockb.assertIsSatisfied();
        Exchange exa = (Exchange)mocka.getExchanges().get(0);
        Exchange exa2 = (Exchange)mocka2.getExchanges().get(0);
        Exchange exb = (Exchange)mockb.getExchanges().get(0);
        Assertions.assertEquals((Object)"<foo/>", (Object)exa.getIn().getBody());
        Assertions.assertEquals(A.class, exb.getIn().getBody().getClass());
        Assertions.assertEquals(B.class, exa2.getIn().getBody().getClass());
        Assertions.assertEquals((Object)"<fooResponse/>", (Object)answer.getIn().getBody(String.class));
    }

    public static class MyTypeConverters
    implements TypeConverters {
        @Converter
        public A toA(String in) {
            return new A();
        }
    }

    public static class A {
    }

    public static class B {
    }

    public static class MyDataFormatDefinition
    extends DataFormatDefinition {
        public MyDataFormatDefinition() {
            super((DataFormat)new DefaultDataFormat(){

                public void marshal(Exchange exchange, Object graph, OutputStream stream) {
                    Assertions.assertEquals(B.class, graph.getClass());
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter(stream));
                    pw.print("<fooResponse/>");
                    pw.close();
                }

                public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
                    BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                    Assertions.assertEquals((Object)"<foo/>", (Object)br.readLine());
                    return new A();
                }
            });
        }
    }
}

