/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.processor.transformer.StringDataTypeTransformer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringDataTypeTransformerTest {
    private final DefaultCamelContext camelContext = new DefaultCamelContext();
    private final StringDataTypeTransformer transformer = new StringDataTypeTransformer();

    @Test
    void shouldRetainStringModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test.txt");
        exchange.getMessage().setBody((Object)"Test");
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        StringDataTypeTransformerTest.assertStringBody((Exchange)exchange, "test.txt", "Test");
    }

    @Test
    void shouldMapFromBinaryToStringModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test1.txt");
        exchange.getMessage().setBody((Object)"Test1".getBytes(StandardCharsets.UTF_8));
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        StringDataTypeTransformerTest.assertStringBody((Exchange)exchange, "test1.txt", "Test1");
    }

    @Test
    void shouldMapFromInputStreamToStringModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test3.txt");
        exchange.getMessage().setBody((Object)new ByteArrayInputStream("Test3".getBytes(StandardCharsets.UTF_8)));
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        StringDataTypeTransformerTest.assertStringBody((Exchange)exchange, "test3.txt", "Test3");
    }

    @Test
    public void shouldLookupDataType() {
        DefaultTransformerRegistry dataTypeRegistry = new DefaultTransformerRegistry((CamelContext)this.camelContext);
        Transformer transformer = dataTypeRegistry.resolveTransformer(new TransformerKey("text-plain"));
        Assertions.assertNotNull((Object)transformer);
        transformer = dataTypeRegistry.resolveTransformer(new TransformerKey("text/plain"));
        Assertions.assertNotNull((Object)transformer);
        transformer = dataTypeRegistry.resolveTransformer(new TransformerKey("camel:text-plain"));
        Assertions.assertNotNull((Object)transformer);
    }

    private static void assertStringBody(Exchange exchange, String key, String content) {
        Assertions.assertEquals((Object)key, (Object)exchange.getMessage().getHeader("file"));
        Assertions.assertEquals(String.class, exchange.getMessage().getBody().getClass());
        Assertions.assertEquals((Object)content, (Object)exchange.getMessage().getBody(String.class));
    }
}

