/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.processor.transformer.DataTypeProcessor;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DataTypeProcessorTest {
    private final DefaultCamelContext camelContext = new DefaultCamelContext();
    private final DataTypeProcessor processor = new DataTypeProcessor();

    DataTypeProcessorTest() {
    }

    @BeforeEach
    void setup() {
        CamelContextAware.trySetCamelContext((Object)this.processor, (CamelContext)this.camelContext);
    }

    @Test
    public void shouldApplyDataTypeTransformerFromAnnotationLookup() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setBody((Object)new ByteArrayInputStream("Test".getBytes(StandardCharsets.UTF_8)));
        this.processor.setToType("uppercase");
        this.processor.process((Exchange)exchange);
        Assertions.assertEquals(String.class, exchange.getMessage().getBody().getClass());
        Assertions.assertEquals((Object)"TEST", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void shouldApplyDataTypeTransformerFromResourceLookup() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setBody((Object)new ByteArrayInputStream("Test".getBytes(StandardCharsets.UTF_8)));
        this.processor.setToType("lowercase");
        this.processor.process((Exchange)exchange);
        Assertions.assertEquals(String.class, exchange.getMessage().getBody().getClass());
        Assertions.assertEquals((Object)"test", (Object)exchange.getMessage().getBody());
    }

    @Test
    public void shouldIgnoreUnknownDataType() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setBody((Object)new ByteArrayInputStream("Test".getBytes(StandardCharsets.UTF_8)));
        this.processor.setIgnoreMissingDataType(true);
        this.processor.setToType("foo:unknown");
        this.processor.process((Exchange)exchange);
        Assertions.assertEquals(ByteArrayInputStream.class, exchange.getMessage().getBody().getClass());
        Assertions.assertEquals((Object)"Test", (Object)exchange.getMessage().getBody(String.class));
    }
}

