/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.transformer;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.processor.transformer.ByteArrayDataTypeTransformer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.apache.camel.support.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteArrayDataTypeTransformerTest {
    private final DefaultCamelContext camelContext = new DefaultCamelContext();
    private final ByteArrayDataTypeTransformer transformer = new ByteArrayDataTypeTransformer();

    @Test
    void shouldRetainBytesModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test.txt");
        exchange.getMessage().setBody((Object)"Test".getBytes(StandardCharsets.UTF_8));
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        ByteArrayDataTypeTransformerTest.assertBinaryBody((Exchange)exchange, "test.txt", "Test");
    }

    @Test
    void shouldTransformFromStringToBytesModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test1.txt");
        exchange.getMessage().setBody((Object)"Test1");
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        ByteArrayDataTypeTransformerTest.assertBinaryBody((Exchange)exchange, "test1.txt", "Test1");
    }

    @Test
    void shouldTransformFromBytesToBytesModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test2.txt");
        exchange.getMessage().setBody((Object)"Test2".getBytes(StandardCharsets.UTF_8));
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        ByteArrayDataTypeTransformerTest.assertBinaryBody((Exchange)exchange, "test2.txt", "Test2");
    }

    @Test
    void shouldTransformFromInputStreamToBytesModel() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.camelContext);
        exchange.getMessage().setHeader("file", (Object)"test3.txt");
        exchange.getMessage().setBody((Object)new ByteArrayInputStream("Test3".getBytes(StandardCharsets.UTF_8)));
        this.transformer.transform(exchange.getMessage(), DataType.ANY, DataType.ANY);
        Assertions.assertTrue((boolean)exchange.getMessage().hasHeaders());
        ByteArrayDataTypeTransformerTest.assertBinaryBody((Exchange)exchange, "test3.txt", "Test3");
    }

    @Test
    public void shouldResolveTransformer() {
        DefaultTransformerRegistry transformerRegistry = new DefaultTransformerRegistry((CamelContext)this.camelContext);
        Transformer transformer = transformerRegistry.resolveTransformer(new TransformerKey("application-octet-stream"));
        Assertions.assertNotNull((Object)transformer);
        transformer = transformerRegistry.resolveTransformer(new TransformerKey("application/octet-stream"));
        Assertions.assertNotNull((Object)transformer);
        transformer = transformerRegistry.resolveTransformer(new TransformerKey("camel:application-octet-stream"));
        Assertions.assertNotNull((Object)transformer);
    }

    private static void assertBinaryBody(Exchange exchange, String key, String content) {
        Assertions.assertEquals((Object)key, (Object)exchange.getMessage().getHeader("file"));
        Assertions.assertEquals(byte[].class, exchange.getMessage().getBody().getClass());
        Assertions.assertEquals((Object)content, (Object)exchange.getMessage().getBody(String.class));
    }
}

