/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle.requests;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class ThrottlingGroupingTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    private static final int MESSAGE_COUNT = 9;
    private static final int TOLERANCE = 50;

    @Test
    public void testGroupingWithSingleConstant() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Kaboom", "max", null);
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testGroupingWithDynamicHeaderExpression() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom", "Saloon"});
        this.getMockEndpoint("mock:resultdynamic").expectedBodiesReceived(new Object[]{"Hello Dynamic World", "Bye Dynamic World"});
        HashMap<String, String> headers = new HashMap<String, String>();
        this.template.sendBodyAndHeaders("seda:a", (Object)"Kaboom", headers);
        this.template.sendBodyAndHeaders("seda:a", (Object)"Saloon", headers);
        headers.put("max", "2");
        this.template.sendBodyAndHeaders("seda:a", (Object)"Hello World", headers);
        this.template.sendBodyAndHeaders("seda:b", (Object)"Bye World", headers);
        headers.put("max", "2");
        headers.put("key", "1");
        this.template.sendBodyAndHeaders("seda:c", (Object)"Hello Dynamic World", headers);
        headers.put("key", "2");
        this.template.sendBodyAndHeaders("seda:c", (Object)"Bye Dynamic World", headers);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSendLotsOfMessagesButOnly3GetThroughWithin2Seconds() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:gresult", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(3);
        resultEndpoint.setResultWaitTime(2000L);
        HashMap<String, String> headers = new HashMap<String, String>();
        for (int i = 0; i < 9; ++i) {
            if (i % 2 == 0) {
                headers.put("key", "1");
            } else {
                headers.put("key", "2");
            }
            this.template.sendBodyAndHeaders("seda:ga", (Object)("<message>" + i + "</message>"), headers);
        }
        resultEndpoint.assertIsSatisfied();
    }

    private void assertThrottlerTiming(long elapsedTimeMs, int throttle, int intervalMs, int messageCount) {
        long minimum = this.calculateMinimum(intervalMs, throttle, messageCount) - 50L;
        long maximum = this.calculateMaximum(intervalMs, throttle, messageCount) + 50L;
        this.log.info("Sent {} exchanges in {}ms, with throttle rate of {} per {}ms. Calculated min {}ms and max {}ms", new Object[]{messageCount, elapsedTimeMs, throttle, intervalMs, minimum, maximum += 500L});
        Assertions.assertTrue((elapsedTimeMs >= minimum ? 1 : 0) != 0, (String)("Should take at least " + minimum + "ms, was: " + elapsedTimeMs));
        Assertions.assertTrue((elapsedTimeMs <= maximum + 50L ? 1 : 0) != 0, (String)("Should take at most " + maximum + "ms, was: " + elapsedTimeMs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sendMessagesAndAwaitDelivery(final int messageCount, final String endpointUri, int threadPoolSize, MockEndpoint receivingEndpoint) throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        try {
            if (receivingEndpoint != null) {
                receivingEndpoint.expectedMessageCount(messageCount);
            }
            long start = System.nanoTime();
            for (int i = 0; i < messageCount; ++i) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        HashMap<String, String> headers = new HashMap<String, String>();
                        if (messageCount % 2 == 0) {
                            headers.put("key", "1");
                        } else {
                            headers.put("key", "2");
                        }
                        ThrottlingGroupingTest.this.template.sendBodyAndHeaders(endpointUri, (Object)"<message>payload</message>", headers);
                    }
                });
            }
            if (receivingEndpoint != null) {
                receivingEndpoint.assertIsSatisfied();
            }
            long l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            return l;
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testSendLotsOfMessagesSimultaneouslyButOnlyGetThroughAsConstantThrottleValue() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:gresult", MockEndpoint.class);
        long elapsed = this.sendMessagesAndAwaitDelivery(9, "direct:ga", 9, resultEndpoint);
        this.assertThrottlerTiming(elapsed, 5, 500, 9);
    }

    @Test
    public void testConfigurationWithHeaderExpression() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:gresult", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(9);
        ExecutorService executor = Executors.newFixedThreadPool(9);
        try {
            this.sendMessagesWithHeaderExpression(executor, resultEndpoint, 5, 500, 9);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private long calculateMinimum(long periodMs, long throttleRate, long messageCount) {
        if (messageCount % throttleRate > 0L) {
            return (long)Math.floor((double)messageCount / (double)throttleRate) * periodMs;
        }
        return (long)(Math.floor((double)messageCount / (double)throttleRate) * (double)periodMs) - periodMs;
    }

    private long calculateMaximum(long periodMs, long throttleRate, long messageCount) {
        return (long)Math.ceil((double)messageCount / (double)throttleRate) * periodMs;
    }

    private void sendMessagesWithHeaderExpression(ExecutorService executor, MockEndpoint resultEndpoint, final int throttle, int intervalMs, final int messageCount) throws InterruptedException {
        resultEndpoint.expectedMessageCount(messageCount);
        long start = System.nanoTime();
        for (int i = 0; i < messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, Object> headers = new HashMap<String, Object>();
                    headers.put("throttleValue", throttle);
                    if (messageCount % 2 == 0) {
                        headers.put("key", "1");
                    } else {
                        headers.put("key", "2");
                    }
                    ThrottlingGroupingTest.this.template.sendBodyAndHeaders("direct:gexpressionHeader", (Object)"<message>payload</message>", headers);
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        this.assertThrottlerTiming(elapsed, throttle, intervalMs, messageCount);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.from("seda:a").throttle((Expression)this.header("max"), 1L).to("mock:result");
                this.from("seda:b").throttle((Expression)this.header("max"), 2L).to("mock:result2");
                this.from("seda:c").throttle((Expression)this.header("max")).correlationExpression((Expression)this.header("key")).to("mock:resultdynamic");
                this.from("seda:ga").throttle((Expression)this.constant(3), (Expression)this.header("key")).timePeriodMillis(1000L).to(new String[]{"log:gresult", "mock:gresult"});
                this.from("direct:ga").throttle((Expression)this.constant(5), (Expression)this.header("key")).timePeriodMillis(500L).to(new String[]{"log:gresult", "mock:gresult"});
                this.from("direct:gexpressionHeader").throttle((Expression)this.header("throttleValue"), (Expression)this.header("key")).timePeriodMillis(500L).to(new String[]{"log:gresult", "mock:gresult"});
            }
        };
    }
}

