/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle.requests;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThrottleDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class ThrottlerDslTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    protected final int messageCount = 9;

    @Test
    public void testDsl() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(9);
        ExecutorService executor = Executors.newFixedThreadPool(9);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 9; ++i) {
            executor.execute(() -> this.template.sendBodyAndHeader("direct:start", (Object)"payload", "ThrottleCount", (Object)1));
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = 4000L;
        long delta = System.currentTimeMillis() - start + 200L;
        Assertions.assertTrue((delta >= minimumTime ? 1 : 0) != 0, (String)("Should take at least " + minimumTime + "ms, was: " + delta));
        executor.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ThrottleDefinition)this.from("direct:start").throttle().message(m -> m.getHeader("ThrottleCount", Integer.class))).timePeriodMillis(500L).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

