/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle.requests;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class ThrottlerAsyncDelayedTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    protected final int messageCount = 9;

    @Test
    public void testSendLotsOfMessages() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(9);
        for (int i = 0; i < 9; ++i) {
            this.template.sendBody("seda:a", (Object)("<message>" + i + "</message>"));
        }
        resultEndpoint.assertIsSatisfied();
    }

    @Test
    public void testSendLotsOfMessagesSimultaneously() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(9);
        ExecutorService executor = Executors.newFixedThreadPool(9);
        for (int i = 0; i < 9; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerAsyncDelayedTest.this.template.sendBody("direct:a", (Object)"<message>payload</message>");
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        this.context.stop();
        executor.shutdownNow();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").throttle(3L).timePeriodMillis(500L).asyncDelayed().to(new String[]{"log:result", "mock:result"});
                this.from("direct:a").throttle(3L).timePeriodMillis(500L).asyncDelayed().to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

