/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisabledOnOs(value={OS.WINDOWS})
public class ThrottlerMethodCallTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ThrottlerMethodCallTest.class);
    private static final int INTERVAL = 100;
    protected final int messageCount = 10;
    private MockEndpoint resultEndpoint;
    private ExecutorService executor;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    public long getConcurrentMessages() {
        return 3L;
    }

    @BeforeEach
    public void prepareTest() {
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        this.resultEndpoint.expectedMessageCount(10);
        this.executor = Executors.newFixedThreadPool(10);
    }

    @AfterEach
    public void cleanupTest() throws InterruptedException {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
            LOG.warn("The tasks did not finish within the expected time");
            this.executor.shutdownNow();
        }
    }

    @Test
    public void testConfigurationWithMethodCallExpression() {
        for (int i = 0; i < 10; ++i) {
            this.executor.execute(() -> this.template.sendBody("direct:expressionMethod", (Object)"<message>payload</message>"));
        }
        try {
            this.resultEndpoint.assertIsSatisfied();
        }
        catch (InterruptedException e) {
            Assertions.fail((Throwable)e);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:expressionMethod").throttle((Expression)this.method("myBean", "getConcurrentMessages")).concurrentRequestsMode().delay(100L).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

