/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle.concurrent;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.junit.jupiter.api.Test;

public class ThrottlerAsyncDelayedCallerRunsTest
extends ContextTestSupport {
    @Test
    public void testThrottler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(6);
        this.template.sendBody("seda:start", (Object)"A");
        this.template.sendBody("seda:start", (Object)"B");
        this.template.sendBody("seda:start", (Object)"C");
        this.template.sendBody("seda:start", (Object)"D");
        this.template.sendBody("seda:start", (Object)"E");
        this.template.sendBody("seda:start", (Object)"F");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder("myThrottler");
                builder.maxQueueSize(Integer.valueOf(2));
                ThrottlerAsyncDelayedCallerRunsTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(builder.build());
                this.from("seda:start").throttle(1L).concurrentRequestsMode().delay(100L).asyncDelayed().executorService("myThrottler").callerRunsWhenRejected(true).to("mock:result");
            }
        };
    }
}

