/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingInflightRoutePolicy;
import org.junit.jupiter.api.Test;

public class ThrottlingInflightRoutePolicyTest
extends ContextTestSupport {
    private final String url = "seda:foo?concurrentConsumers=20";

    @Test
    public void testThrottlingRoutePolicy() throws Exception {
        int size = 100;
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(size - 10);
        for (int i = 0; i < size; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThrottlingInflightRoutePolicy policy = new ThrottlingInflightRoutePolicy();
                policy.setMaxInflightExchanges(10);
                ((ExpressionNode)this.from("seda:foo?concurrentConsumers=20").routePolicy(new RoutePolicy[]{policy}).delay(3L).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }
}

