/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.throttle.ThrottlingException;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlingExceptionRoutePolicyTest
extends ContextTestSupport {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingExceptionRoutePolicyTest.class);
    private final String url = "seda:foo?concurrentConsumers=2";
    private MockEndpoint result;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setUseRouteBuilder(true);
        this.result = this.getMockEndpoint("mock:result");
        this.context.getShutdownStrategy().setTimeout(1L);
    }

    @Test
    public void testThrottlingRoutePolicyClosed() throws Exception {
        int size = 100;
        this.result.expectedMinimumMessageCount(size);
        for (int i = 0; i < size; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=2", (Object)("Message " + i));
            Thread.sleep(3L);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOpenCircuitToPreventMessageThree() throws Exception {
        this.result.reset();
        this.result.expectedMessageCount(2);
        List<String> bodies = Arrays.asList("Message One", "Message Two");
        this.result.expectedBodiesReceivedInAnyOrder(bodies);
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                String msg = (String)exchange.getIn().getBody(String.class);
                exchange.setException((Throwable)new ThrottlingException(msg));
            }
        });
        this.template.sendBody("seda:foo?concurrentConsumers=2", (Object)"Message One");
        this.template.sendBody("seda:foo?concurrentConsumers=2", (Object)"Message Two");
        ServiceSupport consumer = (ServiceSupport)this.context.getRoute("foo").getConsumer();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> ((ServiceSupport)consumer).isSuspended());
        log.debug("sending message three");
        this.template.sendBody("seda:foo?concurrentConsumers=2", (Object)"Message Three");
        this.result.setResultMinimumWaitTime(500L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                int threshold = 2;
                long failureWindow = 30L;
                long halfOpenAfter = 1000L;
                ThrottlingExceptionRoutePolicy policy = new ThrottlingExceptionRoutePolicy(threshold, failureWindow, halfOpenAfter, null);
                policy.setHalfOpenHandler((ThrottlingExceptionHalfOpenHandler)new NeverCloseHandler());
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo?concurrentConsumers=2").routeId("foo").routePolicy(new RoutePolicy[]{policy}).log("${body}")).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }

    public static class NeverCloseHandler
    implements ThrottlingExceptionHalfOpenHandler {
        public boolean isReadyToBeClosed() {
            return false;
        }
    }
}

