/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ThrottlingExceptionRoutePolicyOpenViaConfigTest
extends ContextTestSupport {
    private final String url = "seda:foo?concurrentConsumers=20";
    private MockEndpoint result;
    private ThrottlingExceptionRoutePolicy policy;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.createPolicy();
        super.setUp();
        this.setUseRouteBuilder(true);
        this.result = this.getMockEndpoint("mock:result");
        this.context.getShutdownStrategy().setTimeout(1L);
    }

    protected void createPolicy() {
        int threshold = 2;
        long failureWindow = 30L;
        long halfOpenAfter = 100L;
        boolean keepOpen = false;
        this.policy = new ThrottlingExceptionRoutePolicy(threshold, failureWindow, halfOpenAfter, null, keepOpen);
    }

    @Test
    public void testThrottlingRoutePolicyStartWithAlwaysOpenOffThenToggle() throws Exception {
        int i;
        int size = 5;
        for (i = 0; i < size; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)("MessageRound1 " + i));
            Thread.sleep(3L);
        }
        this.result.expectedMessageCount(size);
        this.result.setResultWaitTime(1000L);
        this.assertMockEndpointsSatisfied();
        this.policy.setKeepOpen(true);
        this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)"MessageTrigger");
        Thread.sleep(500L);
        for (i = 0; i < size; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)("MessageRound2 " + i));
            Thread.sleep(3L);
        }
        Thread.sleep(500L);
        this.result.expectedMessageCount(size + 1);
        this.result.setResultWaitTime(1000L);
        this.assertMockEndpointsSatisfied();
        this.policy.setKeepOpen(false);
        this.result.expectedMessageCount(size * 2 + 1);
        this.result.setResultWaitTime(1000L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo?concurrentConsumers=20").routePolicy(new RoutePolicy[]{ThrottlingExceptionRoutePolicyOpenViaConfigTest.this.policy}).log("${body}")).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }
}

