/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

@EnabledOnOs(value={OS.LINUX, OS.MAC, OS.FREEBSD, OS.OPENBSD}, architectures={"amd64", "aarch64", "ppc64le"}, disabledReason="This test does not run reliably multiple platforms (see CAMEL-21438)")
public class ThrottlingExceptionRoutePolicyKeepOpenOnInitTest
extends ContextTestSupport {
    private final String url = "seda:foo?concurrentConsumers=20";
    private MockEndpoint result;
    private final int size = 5;
    private ThrottlingExceptionRoutePolicy policy;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.createPolicy();
        super.setUp();
        this.setUseRouteBuilder(true);
        this.result = this.getMockEndpoint("mock:result");
        this.context.getShutdownStrategy().setTimeout(1L);
    }

    protected void createPolicy() {
        int threshold = 2;
        long failureWindow = 30L;
        long halfOpenAfter = 100L;
        boolean keepOpen = true;
        this.policy = new ThrottlingExceptionRoutePolicy(threshold, failureWindow, halfOpenAfter, null, keepOpen);
    }

    @Test
    public void testThrottlingRoutePolicyStartWithAlwaysOpenOn() throws Exception {
        this.log.debug("---- sending some messages");
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)("Message " + i));
            Thread.sleep(3L);
        }
        Thread.sleep(500L);
        this.result.expectedMessageCount(0);
        this.result.setResultWaitTime(1000L);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThrottlingRoutePolicyStartWithAlwaysOpenOnThenClose() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:foo?concurrentConsumers=20", (Object)("Message " + i));
            Thread.sleep(3L);
        }
        Thread.sleep(500L);
        this.result.expectedMessageCount(0);
        this.result.setResultWaitTime(1500L);
        this.assertMockEndpointsSatisfied();
        this.policy.setKeepOpen(false);
        this.result.expectedMessageCount(5);
        this.result.setResultWaitTime(1500L);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo?concurrentConsumers=20").routePolicy(new RoutePolicy[]{ThrottlingExceptionRoutePolicyKeepOpenOnInitTest.this.policy}).log("${body}")).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }
}

