/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.throttle.ThrottlingException;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class ThrottlingExceptionRoutePolicyHalfOpenHandlerSedaTest
extends ContextTestSupport {
    private static final Logger log = LoggerFactory.getLogger(ThrottlingExceptionRoutePolicyHalfOpenHandlerSedaTest.class);
    private final String url = "seda:foo?concurrentConsumers=2";
    private MockEndpoint result;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setUseRouteBuilder(true);
        this.result = this.getMockEndpoint("mock:result");
        this.context.getShutdownStrategy().setTimeout(1L);
    }

    @Test
    public void testHalfOpenCircuit() throws Exception {
        this.result.expectedMessageCount(2);
        List<String> bodies = Arrays.asList("Message One", "Message Two");
        this.result.expectedBodiesReceivedInAnyOrder(bodies);
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                String msg = (String)exchange.getIn().getBody(String.class);
                exchange.setException((Throwable)new ThrottlingException(msg));
            }
        });
        this.sendMessage("Message One");
        this.sendMessage("Message Two");
        ServiceSupport consumer = (ServiceSupport)this.context.getRoute("foo").getConsumer();
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> ((ServiceSupport)consumer).isSuspended());
        log.debug("sending message three");
        this.sendMessage("Message Three");
        this.assertMockEndpointsSatisfied();
        this.result.reset();
        this.result.expectedMessageCount(2);
        bodies = Arrays.asList("Message Three", "Message Four");
        this.result.expectedBodiesReceivedInAnyOrder(bodies);
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> ((ServiceSupport)consumer).isStarted());
        log.debug("sending message four");
        this.sendMessage("Message Four");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                int threshold = 2;
                long failureWindow = 30L;
                long halfOpenAfter = 250L;
                ThrottlingExceptionRoutePolicy policy = new ThrottlingExceptionRoutePolicy(threshold, failureWindow, halfOpenAfter, null);
                policy.setHalfOpenHandler((ThrottlingExceptionHalfOpenHandler)new AlwaysCloseHandler());
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo?concurrentConsumers=2").routeId("foo").routePolicy(new RoutePolicy[]{policy}).log("${body}")).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }

    protected void sendMessage(String bodyText) {
        try {
            this.template.sendBody("seda:foo?concurrentConsumers=2", (Object)bodyText);
        }
        catch (Exception e) {
            log.debug("Error sending: {}", (Object)e.getCause().getMessage());
        }
    }

    public static class AlwaysCloseHandler
    implements ThrottlingExceptionHalfOpenHandler {
        public boolean isReadyToBeClosed() {
            return true;
        }
    }
}

