/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.spi.ThreadPoolProfile;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class ThrottlerThreadPoolProfileTest
extends ContextTestSupport {
    @Test
    public void testThreadPool() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ThreadPoolProfile profile = new ThreadPoolProfileBuilder("myPool").poolSize(Integer.valueOf(2)).maxPoolSize(Integer.valueOf(5)).maxQueueSize(Integer.valueOf(10)).build();
                ThrottlerThreadPoolProfileTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(profile);
                this.from("direct:start").throttle((Expression)this.constant(2)).executorService("myPool").to("mock:result");
            }
        };
    }
}

