/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThrottlerPermitTest {
    @Test
    public void testThrottlerPermitWithOldScheduledTime() {
        long timeMillis = System.currentTimeMillis();
        ThrottlePermit throttlePermitOld = new ThrottlePermit(timeMillis - 2592000000L);
        ThrottlePermit throttlePermitNow = new ThrottlePermit(timeMillis);
        ThrottlePermit throttlePermitNow2 = new ThrottlePermit(timeMillis);
        ThrottlePermit throttlePermitFuture = new ThrottlePermit(timeMillis + 1000L);
        Assertions.assertEquals((int)-1, (int)throttlePermitOld.compareTo(throttlePermitNow));
        Assertions.assertEquals((int)0, (int)throttlePermitNow.compareTo(throttlePermitNow2));
        Assertions.assertEquals((int)1, (int)throttlePermitFuture.compareTo(throttlePermitNow));
    }

    private static final class ThrottlePermit
    implements Delayed {
        private volatile long scheduledTime;

        ThrottlePermit(long delayMs) {
            this.setDelayMs(delayMs);
        }

        public void setDelayMs(long delayMs) {
            this.scheduledTime = System.currentTimeMillis() + delayMs;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.scheduledTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
        }
    }
}

