/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.throttle;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class ThrottlerNullEvalTest
extends ContextTestSupport {
    @Test
    public void testFirstNullEvalTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Kaboom", "max", null);
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFirstNoHeaderTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("seda:a", (Object)"Kaboom");
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNullEvalTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Kaboom", "Bye World"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBodyAndHeader("seda:a", (Object)"Kaboom", "max", null);
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNoHeaderTest() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Kaboom", "Bye World"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello World", "max", (Object)2);
        this.template.sendBody("seda:a", (Object)"Kaboom");
        this.template.sendBodyAndHeader("seda:a", (Object)"Bye World", "max", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.from("seda:a").throttle((Expression)this.header("max")).to("mock:result");
            }
        };
    }
}

