/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoutingSlipWithExceptionTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "destinations";
    protected final MyBean myBean = new MyBean();
    private MockEndpoint endEndpoint;
    private MockEndpoint exceptionEndpoint;
    private MockEndpoint aEndpoint;

    @Test
    public void testNoException() throws Exception {
        this.endEndpoint.expectedMessageCount(1);
        this.exceptionEndpoint.expectedMessageCount(0);
        this.aEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithNoExceptionThrowingComponent();
        this.assertEndpointsSatisfied();
    }

    @Test
    public void testWithExceptionThrowingComponentFirstInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.aEndpoint.expectedMessageCount(0);
        this.sendRoutingSlipWithExceptionThrowingComponentFirstInList();
        this.assertEndpointsSatisfied();
    }

    @Test
    public void testWithExceptionThrowingComponentSecondInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.aEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionThrowingComponentSecondInList();
        this.assertEndpointsSatisfied();
    }

    @Test
    public void testWithExceptionSettingComponentFirstInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.aEndpoint.expectedMessageCount(0);
        this.sendRoutingSlipWithExceptionSettingComponentFirstInList();
        this.assertEndpointsSatisfied();
    }

    @Test
    public void testWithExceptionSettingComponentSecondInList() throws Exception {
        this.endEndpoint.expectedMessageCount(0);
        this.exceptionEndpoint.expectedMessageCount(1);
        this.aEndpoint.expectedMessageCount(1);
        this.sendRoutingSlipWithExceptionSettingComponentSecondInList();
        this.assertEndpointsSatisfied();
    }

    private void assertEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((long)5L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{this.endEndpoint, this.exceptionEndpoint, this.aEndpoint});
    }

    protected void sendRoutingSlipWithExceptionThrowingComponentFirstInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"bean:myBean?method=throwException,mock:a");
    }

    protected void sendRoutingSlipWithExceptionThrowingComponentSecondInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a,bean:myBean?method=throwException");
    }

    protected void sendRoutingSlipWithNoExceptionThrowingComponent() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a");
    }

    protected void sendRoutingSlipWithExceptionSettingComponentFirstInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:exceptionSetting,mock:a");
    }

    protected void sendRoutingSlipWithExceptionSettingComponentSecondInList() {
        this.template.sendBodyAndHeader("direct:start", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:a,mock:exceptionSetting");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.endEndpoint = this.resolveMandatoryEndpoint("mock:noexception", MockEndpoint.class);
        this.exceptionEndpoint = this.resolveMandatoryEndpoint("mock:exception", MockEndpoint.class);
        MockEndpoint exceptionSettingEndpoint = this.resolveMandatoryEndpoint("mock:exceptionSetting", MockEndpoint.class);
        this.aEndpoint = this.resolveMandatoryEndpoint("mock:a", MockEndpoint.class);
        exceptionSettingEndpoint.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) {
                exchange.setException((Throwable)new Exception("Throw me!"));
            }
        });
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        Assertions.assertSame((Object)this.myBean, (Object)lookedUpBean, (String)"Lookup of 'myBean' should return same object!");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().routingSlip((Expression)this.header(RoutingSlipWithExceptionTest.ROUTING_SLIP_HEADER)).end()).to("mock:noexception")).doCatch(Exception.class).to("mock:exception");
            }
        };
    }

    public static class MyBean {
        public void throwException() throws Exception {
            throw new Exception("Throw me!");
        }
    }
}

