/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RoutingSlipTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "myHeader";

    @Test
    public void testUpdatingOfRoutingSlipAllDefaults() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{ANSWER});
        y.expectedBodiesReceived(new Object[]{ANSWER});
        z.expectedBodiesReceived(new Object[]{ANSWER});
        this.sendBody("direct:a", ROUTING_SLIP_HEADER, ",");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUpdatingOfRoutingSlipHeaderSet() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{ANSWER});
        y.expectedBodiesReceived(new Object[]{ANSWER});
        z.expectedBodiesReceived(new Object[]{ANSWER});
        this.sendBody("direct:b", "aRoutingSlipHeader", ",");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUpdatingOfRoutingSlipHeaderAndDelimiterSet() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{ANSWER});
        y.expectedBodiesReceived(new Object[]{ANSWER});
        z.expectedBodiesReceived(new Object[]{ANSWER});
        this.sendBody("direct:c", "aRoutingSlipHeader", "#");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testBodyExpression() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"mock:x, mock:y,mock:z"});
        y.expectedBodiesReceived(new Object[]{"mock:x, mock:y,mock:z"});
        z.expectedBodiesReceived(new Object[]{"mock:x, mock:y,mock:z"});
        this.template.sendBody("direct:d", (Object)"mock:x, mock:y,mock:z");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMessagePassingThrough() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBody("direct:a", ROUTING_SLIP_HEADER, ",");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEmptyRoutingSlip() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBodyWithEmptyRoutingSlip();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testNoRoutingSlip() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.sendBodyWithNoRoutingSlip();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody(String endpoint, String header, String delimiter) {
        this.template.sendBodyAndHeader(endpoint, (Object)ANSWER, header, (Object)("mock:x" + delimiter + "mock:y" + delimiter + "mock:z"));
    }

    protected void sendBodyWithEmptyRoutingSlip() {
        this.template.sendBodyAndHeader("direct:a", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"");
    }

    protected void sendBodyWithNoRoutingSlip() {
        this.template.sendBody("direct:a", (Object)ANSWER);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header(RoutingSlipTest.ROUTING_SLIP_HEADER)).to("mock:end");
                this.from("direct:b").routingSlip(ExpressionBuilder.headerExpression((String)"aRoutingSlipHeader"));
                this.from("direct:c").routingSlip((Expression)this.header("aRoutingSlipHeader"), "#");
                this.from("direct:d").routingSlip((Expression)this.body());
            }
        };
    }
}

