/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RoutingSlipPOJOTest
extends ContextTestSupport {
    @Test
    public void testRoutingSlipPOJO() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        foo.expectedBodiesReceived(new Object[]{"Message"});
        result.expectedBodiesReceived(new Object[]{"Message is processed!"});
        this.template.sendBody("direct:a", (Object)"Message");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").bean((Object)new MyRoutingSlipPOJO());
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getMessage().setBody((Object)(String.valueOf(exchange.getIn().getBody()) + " is processed!"));
                    }
                });
            }
        };
    }

    public static class MyRoutingSlipPOJO {
        @RoutingSlip
        public String[] doSomething(String body) {
            return new String[]{"mock:foo", "direct:b", "mock:result"};
        }
    }
}

