/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipIgnoreInvalidEndpointsTest
extends ContextTestSupport {
    @Test
    public void testEndpointResolvedFailedWithIgnoreInvalidEndpoints() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello", "myHeader", (Object)"direct:start ,fail:endpoint, mock:result");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointResolvedFailedWithoutIgnoreInvalidEndpoints() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:b", (Object)"Hello", "myHeader", (Object)"direct:start,fail:endpoint,mock:result");
            Assertions.fail((String)"Expect the exception here.");
        }
        catch (Exception ex) {
            boolean b = ex.getCause() instanceof NoSuchEndpointException;
            Assertions.assertTrue((boolean)b, (String)"Get a wrong cause of the exception");
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header("myHeader")).ignoreInvalidEndpoints().to("mock:end");
                this.from("direct:b").routingSlip((Expression)this.header("myHeader")).to("mock:end");
                this.from("direct:start").transform((Expression)this.constant("Hello World"));
            }
        };
    }
}

