/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RoutingSlipDataModificationTest
extends ContextTestSupport {
    protected static final String ANSWER = "answer";
    protected static final String ROUTING_SLIP_HEADER = "routingSlipHeader";
    protected final MyBean myBean = new MyBean();

    @Test
    public void testModificationOfDataAlongRoute() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        x.expectedBodiesReceived(new Object[]{ANSWER});
        y.expectedBodiesReceived(new Object[]{"answeranswer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)ANSWER, ROUTING_SLIP_HEADER, (Object)"mock:x , bean:myBean?method=modifyData");
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        Assertions.assertSame((Object)this.myBean, (Object)lookedUpBean, (String)"Lookup of 'myBean' should return same object!");
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header(RoutingSlipDataModificationTest.ROUTING_SLIP_HEADER)).to("mock:y");
            }
        };
    }

    public static class MyBean {
        public String modifyData(@Body String body) {
            return body + body;
        }
    }
}

