/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecipientListEventNotifierTest
extends ContextTestSupport {
    private final MyEventNotifier notifier = new MyEventNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    @Test
    public void testRecipientListEventNotifier() throws Exception {
        this.getMockEndpoint("mock:x").expectedMessageCount(1);
        this.getMockEndpoint("mock:y").expectedMessageCount(1);
        this.getMockEndpoint("mock:z").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "myHeader", (Object)"mock:x,mock:y,mock:z");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)5, (int)this.notifier.getSending(), (String)"Should have 5 sending events");
        Assertions.assertEquals((int)5, (int)this.notifier.getSent(), (String)"Should have 5 sent events");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").recipientList((Expression)this.header("myHeader")).to("mock:end");
            }
        };
    }

    private static final class MyEventNotifier
    extends EventNotifierSupport {
        private int sending;
        private int sent;

        private MyEventNotifier() {
        }

        public void notify(CamelEvent event) {
            if (event instanceof CamelEvent.ExchangeSendingEvent) {
                ++this.sending;
            } else {
                ++this.sent;
            }
        }

        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.ExchangeSendingEvent || event instanceof CamelEvent.ExchangeSentEvent;
        }

        public int getSending() {
            return this.sending;
        }

        public int getSent() {
            return this.sent;
        }
    }
}

