/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import org.apache.camel.processor.resequencer.TestComparator;
import org.apache.camel.processor.resequencer.TestObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestComparatorTest {
    private TestComparator c;
    private TestObject e1;
    private TestObject e2;
    private TestObject e3;

    @BeforeEach
    public void setUp() {
        this.c = new TestComparator();
        this.e1 = new TestObject(3);
        this.e2 = new TestObject(4);
        this.e3 = new TestObject(7);
    }

    @Test
    public void testPredecessor() {
        Assertions.assertTrue((boolean)this.c.predecessor(this.e1, this.e2));
        Assertions.assertFalse((boolean)this.c.predecessor(this.e2, this.e1));
        Assertions.assertFalse((boolean)this.c.predecessor(this.e1, this.e3));
        Assertions.assertFalse((boolean)this.c.predecessor(this.e3, this.e1));
        Assertions.assertFalse((boolean)this.c.predecessor(this.e3, this.e3));
    }

    @Test
    public void testSuccessor() {
        Assertions.assertTrue((boolean)this.c.successor(this.e2, this.e1));
        Assertions.assertFalse((boolean)this.c.successor(this.e1, this.e2));
        Assertions.assertFalse((boolean)this.c.successor(this.e3, this.e1));
        Assertions.assertFalse((boolean)this.c.successor(this.e1, this.e3));
        Assertions.assertFalse((boolean)this.c.successor(this.e3, this.e3));
    }

    @Test
    public void testCompare() {
        Assertions.assertTrue((this.c.compare(this.e1, this.e2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.c.compare(this.e2, this.e1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.c.compare(this.e1, this.e3) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.c.compare(this.e3, this.e1) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)this.c.compare(this.e3, this.e3));
    }
}

