/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.processor.resequencer.ResequencerEngineSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResequencerRunner<E>
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ResequencerRunner.class);
    private final Lock lock = new ReentrantLock();
    private final ResequencerEngineSync<E> resequencer;
    private final long interval;
    private boolean cancelRequested;
    private volatile boolean running;

    public ResequencerRunner(ResequencerEngineSync<E> resequencer, long interval) {
        this.resequencer = resequencer;
        this.interval = interval;
        this.cancelRequested = false;
    }

    @Override
    public void run() {
        while (!this.cancelRequested()) {
            this.running = true;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                LOG.info("The test execution was interrupted", (Throwable)e);
            }
            try {
                this.resequencer.deliver();
            }
            catch (Exception e) {
                LOG.info("The test execution was interrupted", (Throwable)e);
            }
        }
        super.run();
        this.running = false;
    }

    public void cancel() {
        this.lock.lock();
        try {
            this.cancelRequested = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean cancelRequested() {
        this.lock.lock();
        try {
            boolean bl = this.cancelRequested;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

