/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.resequencer.MyFileNameExpression;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class ResequencerFileNameTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)new MyFileNameExpression()).stream().timeout(100L).to("mock:result");
            }
        };
    }

    @Test
    public void testStreamResequence() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"20090612-D001", "20090612-D003"});
        this.template.requestBody("direct:start", (Object)"20090612-D003");
        this.template.requestBody("direct:start", (Object)"20090612-D001");
        this.resultEndpoint.assertIsSatisfied();
        this.resultEndpoint.reset();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"20090612-D002", "20090615-D001"});
        this.template.requestBody("direct:start", (Object)"20090615-D001");
        this.template.requestBody("direct:start", (Object)"20090612-D002");
        this.resultEndpoint.assertIsSatisfied();
    }
}

