/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.camel.TestSupport;
import org.apache.camel.processor.resequencer.IntegerComparator;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.ResequencerEngineSync;
import org.apache.camel.processor.resequencer.ResequencerRunner;
import org.apache.camel.processor.resequencer.SequenceBuffer;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.util.StopWatch;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;

class ResequencerEngineTest
extends TestSupport {
    private static final boolean IGNORE_LOAD_TESTS = Boolean.parseBoolean(System.getProperty("ignore.load.tests", "true"));
    private ResequencerEngineSync<Integer> resequencer;
    private ResequencerRunner<Integer> runner;
    private SequenceBuffer<Integer> buffer;

    ResequencerEngineTest() {
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.runner != null) {
            this.runner.cancel();
        }
        if (this.resequencer != null) {
            this.resequencer.stop();
        }
    }

    @Test
    void testTimeout1() throws Exception {
        this.initResequencer(500L);
        this.resequencer.insert(4);
        Assertions.assertNull((Object)this.buffer.poll(250L));
        Assertions.assertEquals((int)4, (Integer)this.buffer.take());
        Assertions.assertEquals((int)4, (Integer)this.resequencer.getLastDelivered());
    }

    @Test
    void testTimeout2() throws Exception {
        this.initResequencer(500L);
        this.resequencer.setLastDelivered(2);
        this.resequencer.insert(4);
        Assertions.assertNull((Object)this.buffer.poll(250L));
        Assertions.assertEquals((int)4, (Integer)this.buffer.take());
        Assertions.assertEquals((int)4, (Integer)this.resequencer.getLastDelivered());
    }

    @Test
    void testTimeout3() throws Exception {
        this.initResequencer(500L);
        this.resequencer.setLastDelivered(3);
        this.resequencer.insert(4);
        Assertions.assertEquals((int)4, (Integer)this.buffer.poll(5000L));
        Assertions.assertEquals((int)4, (Integer)this.resequencer.getLastDelivered());
    }

    @Test
    void testTimeout4() throws Exception {
        this.initResequencer(500L);
        this.resequencer.setLastDelivered(2);
        this.resequencer.insert(4);
        this.resequencer.insert(3);
        Assertions.assertEquals((int)3, (Integer)this.buffer.poll(5000L));
        Assertions.assertEquals((int)4, (Integer)this.buffer.poll(5000L));
        Assertions.assertEquals((int)4, (Integer)this.resequencer.getLastDelivered());
    }

    @DisabledIf(value="isIgnoreLoadTests", disabledReason="Enabled only when the System property 'ignore.load.tests' is not set to 'true'")
    @Test
    void testRandom() throws Exception {
        int i;
        int input = 1000;
        this.initResequencer(1000L);
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i2 = 0; i2 < input; ++i2) {
            list.add(i2);
        }
        Random random = new Random(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder(4000);
        sb.append("Input sequence: ");
        StopWatch watch = new StopWatch();
        for (i = input; i > 0; --i) {
            int r = random.nextInt(i);
            int next = (Integer)list.remove(r);
            sb.append(next).append(" ");
            this.resequencer.insert(next);
        }
        this.log.info(sb.toString());
        sb.delete(0, sb.length());
        sb.append("Output sequence: ");
        for (i = 0; i < input; ++i) {
            sb.append(this.buffer.take()).append(" ");
        }
        this.log.info(sb.toString());
        this.log.info("Duration = {} ms", (Object)watch.taken());
    }

    @DisabledIf(value="isIgnoreLoadTests", disabledReason="Enabled only when the System property 'ignore.load.tests' is not set to 'true'")
    @Test
    void testReverse() throws Exception {
        this.initResequencer(1L);
        for (int i = 99; i >= 0; --i) {
            this.resequencer.insert(i);
        }
        StringBuilder sb = new StringBuilder(2500);
        sb.append("Output sequence: ");
        for (int i = 0; i < 100; ++i) {
            sb.append(this.buffer.take()).append(" ");
        }
        this.log.info(sb.toString());
    }

    private void initResequencer(long timeout) {
        this.buffer = new SequenceBuffer();
        ResequencerEngine engine = new ResequencerEngine((SequenceElementComparator)new IntegerComparator());
        engine.setSequenceSender(this.buffer);
        engine.setTimeout(timeout);
        engine.start();
        this.resequencer = new ResequencerEngineSync(engine);
        this.runner = new ResequencerRunner<Integer>(this.resequencer, 50L);
        this.runner.start();
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).until(this.runner::isRunning);
    }

    boolean isIgnoreLoadTests() {
        return IGNORE_LOAD_TESTS;
    }
}

