/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceSender;

public class ResequencerEngineSync<E> {
    private final Lock lock = new ReentrantLock();
    private final ResequencerEngine<E> resequencer;

    public ResequencerEngineSync(ResequencerEngine<E> resequencer) {
        this.resequencer = resequencer;
    }

    public void stop() {
        this.lock.lock();
        try {
            this.resequencer.stop();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.resequencer.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getTimeout() {
        this.lock.lock();
        try {
            long l = this.resequencer.getTimeout();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTimeout(long timeout) {
        this.lock.lock();
        try {
            this.resequencer.setTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SequenceSender<E> getSequenceSender() {
        this.lock.lock();
        try {
            SequenceSender sequenceSender = this.resequencer.getSequenceSender();
            return sequenceSender;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSequenceSender(SequenceSender<E> sequenceSender) {
        this.lock.lock();
        try {
            this.resequencer.setSequenceSender(sequenceSender);
        }
        finally {
            this.lock.unlock();
        }
    }

    E getLastDelivered() {
        this.lock.lock();
        try {
            Object object = this.resequencer.getLastDelivered();
            return (E)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setLastDelivered(E o) {
        this.lock.lock();
        try {
            this.resequencer.setLastDelivered(o);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void insert(E o) {
        this.lock.lock();
        try {
            this.resequencer.insert(o);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deliver() throws Exception {
        this.lock.lock();
        try {
            this.resequencer.deliver();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean deliverNext() throws Exception {
        this.lock.lock();
        try {
            boolean bl = this.resequencer.deliverNext();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

