/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Isolated
public class ResequencerBatchOrderTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ResequencerBatchOrderTest.class);

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").resequence((Expression)this.body()).batch().size(2).timeout(50L).to("mock:result");
            }
        };
    }

    @Test
    public void testResequencerBatch() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.testIteration(i);
        }
    }

    private void testIteration(int i) throws Exception {
        MockEndpoint me = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        me.reset();
        me.expectedMessageCount(4);
        LOG.info("Run #{}", (Object)i);
        this.template.sendBody("direct:start", (Object)"4");
        this.template.sendBody("direct:start", (Object)"1");
        this.template.sendBody("direct:start", (Object)"3");
        this.template.sendBody("direct:start", (Object)"2");
        this.assertMockEndpointsSatisfied();
        String a = (String)((Exchange)me.getExchanges().get(0)).getIn().getBody(String.class);
        String b = (String)((Exchange)me.getExchanges().get(1)).getIn().getBody(String.class);
        String c = (String)((Exchange)me.getExchanges().get(2)).getIn().getBody(String.class);
        String d = (String)((Exchange)me.getExchanges().get(3)).getIn().getBody(String.class);
        String line = a + b + c + d;
        LOG.info("Order: {}", (Object)line);
        Assertions.assertTrue(("1423".equals(line) || "1234".equals(line) ? 1 : 0) != 0, (String)("Line was " + line));
    }
}

