/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

public class RouteScopedOnExceptionSameTypeTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOnExceptionExactType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)this.from("direct:foo").onException(IllegalArgumentException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionDifferentType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)this.from("direct:foo").onException(IOException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionSameTypeRouteLast() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:foo").onException(IllegalArgumentException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionDifferentTypeRouteLast() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:foo").onException(IOException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionExactTypeDLC() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)this.from("direct:foo").onException(IllegalArgumentException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:dlc").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testTwoOnExceptionExactType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.from("direct:start").onException(IOException.class).handled(true).to("mock:io")).end().onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
                ((OnExceptionDefinition)((OnExceptionDefinition)this.from("direct:foo").onException(IOException.class).handled(true).to("mock:io")).end().onException(IllegalArgumentException.class).handled(true).to("mock:foo")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:io").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionRouteAndGlobalExactType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:foo");
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionRouteAndGlobalDifferentType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IOException.class).handled(true).to("mock:foo");
                ((OnExceptionDefinition)this.from("direct:start").onException(IllegalArgumentException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionRouteAndOnlyGlobalExactType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:foo");
                ((OnExceptionDefinition)this.from("direct:start").onException(IOException.class).handled(true).to("mock:damn")).end().throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionRouteAndOnlyGlobalBestMatchType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IOException.class).handled(true).to("mock:foo");
                ((OnExceptionDefinition)this.from("direct:start").onException(Exception.class).handled(true).to("mock:damn")).end().throwException((Exception)new FileNotFoundException("unknown.txt"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionRouteBestMatchAndGlobalSameType() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IOException.class).handled(true).to("mock:foo");
                ((OnExceptionDefinition)this.from("direct:start").onException(IOException.class).handled(true).to("mock:damn")).end().throwException((Exception)new FileNotFoundException("unknown.txt"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

