/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RedeliverEntireRouteTest
extends ContextTestSupport {
    @Test
    public void testRedeliverEntireRoute() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(4);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).redeliveryDelay(0L);
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("direct:foo")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).log("Calling foo route redelivery count: ${header.CamelRedeliveryCounter}")).to("mock:b")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

