/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.TypeConverterSupport;
import org.junit.jupiter.api.Test;

public class OnExceptionWrappedExceptionTest
extends ContextTestSupport {
    @Test
    public void testWrappedException() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:wrapped").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                OnExceptionWrappedExceptionTest.this.context.getTypeConverterRegistry().addTypeConverter(LocalDateTime.class, String.class, (TypeConverter)new MyLocalDateTimeConverter());
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                this.onException(IllegalArgumentException.class).handled(true).to("mock:wrapped");
                ((RouteDefinition)this.from("direct:start").convertBodyTo(LocalDateTime.class)).to("mock:end");
            }
        };
    }

    private static class MyLocalDateTimeConverter
    extends TypeConverterSupport {
        private MyLocalDateTimeConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)new IllegalArgumentException("Bad Data"));
        }
    }

    public static class LocalDateTime {
    }
}

