/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class OnExceptionWhenSimpleOgnlTest
extends ContextTestSupport {
    @Test
    public void testOnExceptionWhenSimpleOgnl() throws Exception {
        this.getMockEndpoint("mock:three").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(MyException.class).onWhen((Predicate)this.simple("${exception.info.state} == 3")).handled(true).to("mock:three");
                this.from("direct:start").throwException((Exception)new MyException(3));
            }
        };
    }

    public static final class MyExceptionInfo {
        private final int state;

        public MyExceptionInfo(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }

    public static final class MyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final MyExceptionInfo info;

        public MyException(int state) {
            this.info = new MyExceptionInfo(state);
        }

        public MyExceptionInfo getInfo() {
            return this.info;
        }
    }
}

