/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionUseOriginalMessageTest
extends ContextTestSupport {
    private static final String HELLO_WORLD = "Hello World";
    private static final String TEST_STRING = "<firstName>James</firstName>";

    @Test
    public void testOnExceptionError() throws Exception {
        this.getMockEndpoint("mock:middle").expectedBodiesReceived(new Object[]{HELLO_WORLD});
        ((MockValueBuilder)this.getMockEndpoint("mock:middle").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.getMockEndpoint("mock:end").expectedBodiesReceived(new Object[]{HELLO_WORLD});
        ((MockValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:a", (Object)HELLO_WORLD);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionStreamReset() throws Exception {
        this.getMockEndpoint("mock:middle").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:middle").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        InputStreamCache cache = new InputStreamCache(TEST_STRING.getBytes());
        this.template.sendBody("direct:a", (Object)cache);
        this.assertMockEndpointsSatisfied();
        String result = (String)((Exchange)this.getMockEndpoint("mock:end").getExchanges().get(0)).getIn().getBody(String.class);
        Assertions.assertTrue((boolean)result.contains(TEST_STRING));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).useOriginalMessage().handled(true).to("seda:test");
                ((RouteDefinition)this.from("direct:a").setExchangePattern(ExchangePattern.InOut)).process((Processor)new MyProcessor());
                ((RouteDefinition)this.from("seda:test").to("mock:middle")).to("mock:end");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            String request = (String)exchange.getIn().getBody(String.class);
            if (!request.equals(OnExceptionUseOriginalMessageTest.HELLO_WORLD)) {
                exchange.getIn().setBody((Object)OnExceptionUseOriginalMessageTest.HELLO_WORLD);
            }
            exchange.getMessage().setBody((Object)"Error body");
            throw new IllegalArgumentException("Get a wrong message");
        }
    }
}

