/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.StreamCache;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionUseOriginalMessageStreamTwoTest
extends ContextTestSupport {
    private final List<String> list1 = new ArrayList<String>();
    private final List<String> list2 = new ArrayList<String>();

    @Test
    void convertUseOriginalMessage() {
        String data = "data";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        this.template.sendBody("direct:start", (Object)is);
        Assertions.assertEquals((Object)this.list1.get(0), (Object)this.list2.get(0));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).useOriginalMessage().process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertInstanceOf(StreamCache.class, (Object)exchange.getMessage().getBody());
                        String s = (String)exchange.getMessage().getBody(String.class);
                        OnExceptionUseOriginalMessageStreamTwoTest.this.list1.add(s);
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertInstanceOf(StreamCache.class, (Object)exchange.getMessage().getBody());
                        String s = (String)exchange.getMessage().getBody(String.class);
                        OnExceptionUseOriginalMessageStreamTwoTest.this.list2.add(s);
                    }
                })).handled(true);
                this.from("direct:start").unmarshal((DataFormat)new MyDataFormat());
            }
        };
    }

    public static class MyDataFormat
    extends ServiceSupport
    implements DataFormat {
        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
            String s = IOConverter.toString((InputStream)stream, (Exchange)exchange);
            throw new MyDataFormatException(s);
        }
    }

    public static class MyDataFormatException
    extends Exception {
        public MyDataFormatException(String message) {
            super(message);
        }
    }
}

