/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionUseOriginalMessageStreamTest
extends ContextTestSupport {
    @Test
    void convertBodyWithStreamCache() {
        String data = "data";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:convertBodyWithStreamCache", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void convertBodyWithoutStreamCache() {
        String data = "data";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:convertBodyWithoutStreamCache", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void unmarshallWithStreamCache() {
        String data = "{\"test\": \"data\"";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:unmarshallWithStreamCache", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void unmarshallWithoutStreamCache() {
        String data = "{\"test\": \"data\"";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:unmarshallWithoutStreamCache", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void unmarshallInvalidWithoutStreamCache() {
        String data = "{\"test\": \"data\"";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:convertBodyInvalidUnmarshallWithoutStreamCache", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void noStreamReading() {
        String data = "data";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:noStreamReading", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    @Test
    void setBodyAsExchangeProperty() {
        String data = "data";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        Object out = this.template.requestBody("direct:setBodyAsExchangeProperty", (Object)is, Object.class);
        Assertions.assertEquals((Object)data, (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(new Class[]{ExceptionOne.class, MyDataFormatException.class}).useOriginalMessage().convertBodyTo(String.class)).handled(true);
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(ExceptionTwo.class).setBody((Expression)this.exchangeProperty("OriginalBody"))).convertBodyTo(String.class)).handled(true);
                ((RouteDefinition)this.from("direct:convertBodyWithStreamCache").streamCaching().convertBodyTo(String.class)).throwException((Exception)new ExceptionOne());
                ((RouteDefinition)this.from("direct:convertBodyWithoutStreamCache").noStreamCaching().convertBodyTo(String.class)).throwException((Exception)new ExceptionOne());
                ((RouteDefinition)this.from("direct:unmarshallWithStreamCache").streamCaching().unmarshal((DataFormat)new MyDataFormat())).throwException((Exception)new ExceptionOne());
                ((RouteDefinition)this.from("direct:unmarshallWithoutStreamCache").noStreamCaching().unmarshal((DataFormat)new MyDataFormat())).throwException((Exception)new ExceptionOne());
                ((RouteDefinition)this.from("direct:convertBodyInvalidUnmarshallWithoutStreamCache").noStreamCaching().convertBodyTo(String.class)).unmarshal((DataFormat)new MyDataFormat());
                this.from("direct:noStreamReading").streamCaching().throwException((Exception)new ExceptionOne());
                ((RouteDefinition)((RouteDefinition)this.from("direct:setBodyAsExchangeProperty").noStreamCaching().convertBodyTo(String.class)).setProperty("OriginalBody", (Expression)this.body())).throwException((Exception)new ExceptionTwo());
            }
        };
    }

    public static class MyDataFormat
    extends ServiceSupport
    implements DataFormat {
        public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
            String s = IOConverter.toString((InputStream)stream, (Exchange)exchange);
            throw new MyDataFormatException(s);
        }
    }

    public static class MyDataFormatException
    extends Exception {
        public MyDataFormatException(String message) {
            super(message);
        }
    }

    public static class ExceptionTwo
    extends Exception {
    }

    public static class ExceptionOne
    extends Exception {
    }
}

