/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyOwnHandlerBean;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OnExceptionRouteWithDefaultErrorHandlerTest
extends ContextTestSupport {
    private MyOwnHandlerBean myOwnHandlerBean;
    private MyServiceBean myServiceBean;

    @Test
    public void testNoError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFunctionalError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Func</user></order>");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"<order><type>myType</type><user>Func</user></order>", (Object)this.myOwnHandlerBean.getPayload());
    }

    @Test
    public void testTechnicalError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>Tech</user></order>");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.myOwnHandlerBean.getPayload());
    }

    @Test
    public void testErrorWhileHandlingException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"<order><type>myType</type><user>FuncError</user></order>");
            Assertions.fail((String)"Should throw a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            Assertions.assertEquals((Object)"Damn something did not work", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertNull((Object)this.myOwnHandlerBean.getPayload());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.myOwnHandlerBean = new MyOwnHandlerBean();
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myOwnHandler", (Object)this.myOwnHandlerBean);
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(5));
                this.onException(MyTechnicalException.class).maximumRedeliveries(0).handled(true);
                this.onException(MyFunctionalException.class).maximumRedeliveries(0).handled(true).to("bean:myOwnHandler");
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("//type = 'myType'")).to("bean:myServiceBean")).end().to("mock:result");
            }
        };
    }
}

