/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionRouteIdTest
extends ContextTestSupport {
    @Test
    public void testOnExceptionRouteId() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RouteDefinition route = this.context.getRouteDefinition("foo");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"foo", (Object)route.getId());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).id("myError")).maximumRedeliveries(0).handled(true).setHeader("error", (Expression)this.constant("true"))).end().stop();
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:foo")).end();
            }
        };
    }
}

