/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Header;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionRetryUntilWithDefaultErrorHandlerTest
extends ContextTestSupport {
    private static int invoked;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myRetryHandler", (Object)new MyRetryBean());
        return jndi;
    }

    @Test
    public void testRetryUntil() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(1).logStackTrace(false));
                ((ProcessorDefinition)this.onException(MyFunctionalException.class).retryWhile((Predicate)this.method("myRetryHandler")).redeliveryDelay(0L).handled(true).transform().constant((Object)"Sorry")).stop();
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this");
                    }
                });
            }
        });
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        Assertions.assertEquals((Object)"Sorry", (Object)out);
        Assertions.assertEquals((int)3, (int)invoked);
    }

    public static class MyRetryBean {
        public boolean retry(@Header(value="CamelRedeliveryCounter") Integer counter, @Body String body, @ExchangeException Exception causedBy) {
            ++invoked;
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            boolean b = causedBy instanceof MyFunctionalException;
            Assertions.assertTrue((boolean)b);
            return counter < 3;
        }
    }
}

