/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionRecursionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testRecursionDirect() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Throwable.class).to("mock:c")).to("direct:handle");
                ((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).throwException((Exception)new IllegalStateException("Bad state"))).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:handle").to("mock:d")).log("Handling exception")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(2);
        this.getMockEndpoint("mock:d").expectedMessageCount(2);
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRecursionDirectNoErrorHandler() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Throwable.class).to("mock:c")).to("direct:handle");
                ((RouteDefinition)((RouteDefinition)this.from("direct:test").to("mock:a")).throwException((Exception)new IllegalStateException("Bad state"))).to("mock:b");
                ((RouteDefinition)((RouteDefinition)this.from("direct:handle").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:d")).log("Handling exception")).throwException((Exception)new NullPointerException("A NPE error here"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:d").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:test", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            NullPointerException npe = OnExceptionRecursionTest.assertIsInstanceOf(NullPointerException.class, e.getCause());
            Assertions.assertEquals((Object)"A NPE error here", (Object)npe.getMessage());
            IllegalStateException ise = OnExceptionRecursionTest.assertIsInstanceOf(IllegalStateException.class, npe.getSuppressed()[0]);
            Assertions.assertEquals((Object)"Bad state", (Object)ise.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

