/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionProcessorInspectCausedExceptionWithDefaultErrorHandlerTest
extends ContextTestSupport {
    @Test
    public void testInspectExceptionByProcessor() throws Exception {
        this.getMockEndpoint("mock:myerror").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3));
                this.onException(MyFunctionalException.class).process((Processor)new MyFunctionFailureHandler());
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this");
                    }
                });
            }
        };
    }

    public static class MyFunctionFailureHandler
    implements Processor {
        public void process(Exchange exchange) {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            Assertions.assertNotNull((Object)caused);
            exchange.getContext().createProducerTemplate().send("mock:myerror", exchange);
        }
    }
}

