/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionProcessorInspectCausedExceptionTest
extends ContextTestSupport {
    @Test
    public void testInspectExceptionByProcessor() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:myerror").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(MyFunctionalException.class).process((Processor)new MyFunctionFailureHandler())).stop();
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this");
                    }
                });
            }
        };
    }

    public static class MyFunctionFailureHandler
    implements Processor {
        public void process(Exchange exchange) {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            Assertions.assertNotNull((Object)caused);
            exchange.getContext().createProducerTemplate().send("mock:myerror", exchange);
        }
    }
}

