/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionOccurredProcessorTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myProcessor", (Object)new MyProcessor());
        return jndi;
    }

    @Test
    public void testOnExceptionOccurred() throws Exception {
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyProcessor myProcessor = (MyProcessor)this.context.getRegistry().lookupByNameAndType("myProcessor", MyProcessor.class);
        Assertions.assertEquals((int)4, (int)myProcessor.getInvoked());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MyProcessor myProcessor = (MyProcessor)OnExceptionOccurredProcessorTest.this.context.getRegistry().lookupByNameAndType("myProcessor", MyProcessor.class);
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(3).redeliveryDelay(0L).onExceptionOccurred((Processor)myProcessor));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("start").to("log:a")).to("direct:foo")).to("log:b");
                this.from("direct:foo").routeId("foo").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        private int invoked;

        public void process(Exchange exchange) {
            ++this.invoked;
            String rid = (String)exchange.getProperty("CamelFailureRouteId", String.class);
            Assertions.assertEquals((Object)"foo", (Object)rid);
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

