/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import jakarta.xml.soap.SOAPException;
import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionMisconfiguredTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testOnExceptionMisconfigured() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class);
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"OnException[[java.lang.Exception] -> []] is not configured.", (Object)iae.getMessage());
        }
    }

    @Test
    public void testOnExceptionMisconfigured2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).end();
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"OnException[[java.lang.Exception] -> []] is not configured.", (Object)iae.getMessage());
        }
    }

    @Test
    public void testOnExceptionMisconfigured3() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(new Class[0]);
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"OnException[[java.lang.Exception] -> []] is not configured.", (Object)iae.getMessage());
        }
    }

    @Test
    public void testOnExceptionMisconfigured4() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(new Class[0]).end();
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"OnException[[java.lang.Exception] -> []] is not configured.", (Object)iae.getMessage());
        }
    }

    @Test
    public void testOnExceptionMisconfigured5() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").onException(new Class[0]).end().to("mock:result");
            }
        });
        try {
            this.context.start();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertTrue((boolean)iae.getMessage().startsWith("At least one exception must be configured"));
        }
    }

    @Test
    public void testOnExceptionNotMisconfigured() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(new Class[0]).handled(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    @Test
    public void testOnExceptionNotMisconfigured2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(new Class[0]).continued(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    @Test
    public void testOnExceptionNotMisconfigured3() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    @Test
    public void testOnExceptionNotMisconfigured4() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).continued(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    @Test
    public void testOnExceptionNotMisconfigured5() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.from("direct:start").onException(SOAPException.class).onException(IOException.class).to("mock:error")).end().to("mock:result");
            }
        });
        this.context.start();
    }
}

