/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionHandledThrowsExceptionTest
extends ContextTestSupport {
    @Test
    public void testHandled() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            IllegalArgumentException iae = OnExceptionHandledThrowsExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            Assertions.assertEquals((Object)"Another Forced", (Object)iae.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(IOException.class).handled(e -> {
                    throw new IllegalArgumentException("Another Forced");
                }).to("log:foo?showAll=true")).to("mock:handled");
                this.from("direct:start").throwException((Exception)new IOException("Forced"));
            }
        };
    }
}

